   IPLR           d                  #include <metal_stdlib>
#include <simd/simd.h>

using namespace metal;

struct point_mesh_gradient_fragment_main_out
{
    float4 fragColor [[color(0)]];
};

struct point_mesh_gradient_fragment_main_in
{
    float2 _fragCoord [[user(locn0)]];
};

fragment point_mesh_gradient_fragment_main_out point_mesh_gradient_fragment_main(point_mesh_gradient_fragment_main_in in [[stage_in]], constant float2& uSize [[buffer(0)]], constant float3& uVars [[buffer(1)]], constant float2& uPoint1 [[buffer(2)]], constant float2& uPoint2 [[buffer(3)]], constant float2& uPoint3 [[buffer(4)]], constant float2& uPoint4 [[buffer(5)]], constant float2& uPoint5 [[buffer(6)]], constant float2& uPoint6 [[buffer(7)]], constant float3& uColor1 [[buffer(8)]], constant float3& uColor2 [[buffer(9)]], constant float3& uColor3 [[buffer(10)]], constant float3& uColor4 [[buffer(11)]], constant float3& uColor5 [[buffer(12)]], constant float3& uColor6 [[buffer(13)]])
{
    point_mesh_gradient_fragment_main_out out = {};
    float2 _141 = in._fragCoord / uSize;
    float3 _522;
    float _523;
    if (uVars.z > 0.0)
    {
        float _323 = length(_141 - uPoint1);
        float _331 = 1.0 / powr((_323 == 0.0) ? 1.0 : _323, uVars.x);
        _523 = _331;
        _522 = uColor1 * _331;
    }
    else
    {
        _523 = 0.0;
        _522 = float3(0.0);
    }
    float3 _527;
    float _528;
    if (uVars.z > 1.0)
    {
        float _346 = length(_141 - uPoint2);
        float _354 = 1.0 / powr((_346 == 0.0) ? 1.0 : _346, uVars.x);
        _528 = _523 + _354;
        _527 = _522 + (uColor2 * _354);
    }
    else
    {
        _528 = _523;
        _527 = _522;
    }
    float3 _532;
    float _533;
    if (uVars.z > 2.0)
    {
        float _369 = length(_141 - uPoint3);
        float _377 = 1.0 / powr((_369 == 0.0) ? 1.0 : _369, uVars.x);
        _533 = _528 + _377;
        _532 = _527 + (uColor3 * _377);
    }
    else
    {
        _533 = _528;
        _532 = _527;
    }
    float3 _537;
    float _538;
    if (uVars.z > 3.0)
    {
        float _392 = length(_141 - uPoint4);
        float _400 = 1.0 / powr((_392 == 0.0) ? 1.0 : _392, uVars.x);
        _538 = _533 + _400;
        _537 = _532 + (uColor4 * _400);
    }
    else
    {
        _538 = _533;
        _537 = _532;
    }
    float3 _542;
    float _543;
    if (uVars.z > 4.0)
    {
        float _415 = length(_141 - uPoint5);
        float _423 = 1.0 / powr((_415 == 0.0) ? 1.0 : _415, uVars.x);
        _543 = _538 + _423;
        _542 = _537 + (uColor5 * _423);
    }
    else
    {
        _543 = _538;
        _542 = _537;
    }
    float _547;
    float3 _548;
    if (uVars.z > 5.0)
    {
        float _438 = length(_141 - uPoint6);
        float _446 = 1.0 / powr((_438 == 0.0) ? 1.0 : _438, uVars.x);
        _548 = _542 + (uColor6 * _446);
        _547 = _543 + _446;
    }
    else
    {
        _548 = _542;
        _547 = _543;
    }
    float3 _549;
    if (_547 != 0.0)
    {
        _549 = _548 / float3(_547);
    }
    else
    {
        _549 = _548;
    }
    float2 _290 = in._fragCoord * 0.100000001490116119384765625;
    out.fragColor = float4(powr(mix(_549, _549 * (fma(fract(sin(dot(_290 * 12.80000019073486328125, float2(12.98980045318603515625, 78.233001708984375))) * 43758.546875), 0.0625, fma(fract(sin(dot(_290 * 6.400000095367431640625, float2(12.98980045318603515625, 78.233001708984375))) * 43758.546875), 0.125, fma(fract(sin(dot(_290 * 1.60000002384185791015625, float2(12.98980045318603515625, 78.233001708984375))) * 43758.546875), 0.5, fract(sin(dot(_290 * 3.2000000476837158203125, float2(12.98980045318603515625, 78.233001708984375))) * 43758.546875) * 0.25))) * 1.06666672229766845703125), float3(uVars.y * (-1.0))), float3(0.4545454680919647216796875)), 1.0);
    return out;
}

           \         l  0        |   @      "(   
                                    uColor6 Z(                                       uColor5 (                                       uColor4 (   
                                    uColor3 (   	                                    uColor2 :(                                       uColor1 r(                                       uPoint6 (                                       uPoint5 (                                       uPoint4 (                                       uPoint3 R(                                       uPoint2 (                                       uPoint1 (                                       uVars                                    uSize   !   point_mesh_gradient_fragment_main               $         // This SkSL shader is autogenerated by spirv-cross.

float4 flutter_FragCoord;

uniform vec2 uSize;
uniform vec3 uVars;
uniform vec2 uPoint1;
uniform vec2 uPoint2;
uniform vec2 uPoint3;
uniform vec2 uPoint4;
uniform vec2 uPoint5;
uniform vec2 uPoint6;
uniform vec3 uColor1;
uniform vec3 uColor2;
uniform vec3 uColor3;
uniform vec3 uColor4;
uniform vec3 uColor5;
uniform vec3 uColor6;

vec4 fragColor;

float uBlend;
float uNoiseIntensity;
float uNumPoints;

vec2 FLT_flutter_local_FlutterFragCoord()
{
    return flutter_FragCoord.xy;
}

void FLT_flutter_local_processPoint(vec2 point, vec3 color, vec2 uv, float blend, inout vec3 sum, inout float valence)
{
    float distance = length(uv - point);
    if (distance == 0.0)
    {
        distance = 1.0;
    }
    float w = 1.0 / pow(distance, blend);
    sum += (color * w);
    valence += w;
}

float FLT_flutter_local_noise(vec2 st)
{
    return fract(sin(dot(st, vec2(12.98980045318603515625, 78.233001708984375))) * 43758.546875);
}

float FLT_flutter_local_complexNoise(vec2 st)
{
    vec2 param = st * 1.60000002384185791015625;
    float n1 = FLT_flutter_local_noise(param);
    vec2 param_1 = st * 3.2000000476837158203125;
    float n2 = FLT_flutter_local_noise(param_1);
    vec2 param_2 = st * 6.400000095367431640625;
    float n3 = FLT_flutter_local_noise(param_2);
    vec2 param_3 = st * 12.80000019073486328125;
    float n4 = FLT_flutter_local_noise(param_3);
    float totalNoise = (((n1 * 0.5) + (n2 * 0.25)) + (n3 * 0.125)) + (n4 * 0.0625);
    return totalNoise / 0.9375;
}

void FLT_main()
{
    uBlend = uVars.x;
    uNoiseIntensity = uVars.y;
    uNumPoints = uVars.z;
    vec2 uv = FLT_flutter_local_FlutterFragCoord() / uSize;
    float blend = uBlend;
    vec3 sum = vec3(0.0);
    float valence = 0.0;
    if (uNumPoints > 0.0)
    {
        vec2 param_4 = uPoint1;
        vec3 param_5 = uColor1;
        vec2 param_6 = uv;
        float param_7 = blend;
        vec3 param_8 = sum;
        float param_9 = valence;
        FLT_flutter_local_processPoint(param_4, param_5, param_6, param_7, param_8, param_9);
        sum = param_8;
        valence = param_9;
    }
    if (uNumPoints > 1.0)
    {
        vec2 param_10 = uPoint2;
        vec3 param_11 = uColor2;
        vec2 param_12 = uv;
        float param_13 = blend;
        vec3 param_14 = sum;
        float param_15 = valence;
        FLT_flutter_local_processPoint(param_10, param_11, param_12, param_13, param_14, param_15);
        sum = param_14;
        valence = param_15;
    }
    if (uNumPoints > 2.0)
    {
        vec2 param_16 = uPoint3;
        vec3 param_17 = uColor3;
        vec2 param_18 = uv;
        float param_19 = blend;
        vec3 param_20 = sum;
        float param_21 = valence;
        FLT_flutter_local_processPoint(param_16, param_17, param_18, param_19, param_20, param_21);
        sum = param_20;
        valence = param_21;
    }
    if (uNumPoints > 3.0)
    {
        vec2 param_22 = uPoint4;
        vec3 param_23 = uColor4;
        vec2 param_24 = uv;
        float param_25 = blend;
        vec3 param_26 = sum;
        float param_27 = valence;
        FLT_flutter_local_processPoint(param_22, param_23, param_24, param_25, param_26, param_27);
        sum = param_26;
        valence = param_27;
    }
    if (uNumPoints > 4.0)
    {
        vec2 param_28 = uPoint5;
        vec3 param_29 = uColor5;
        vec2 param_30 = uv;
        float param_31 = blend;
        vec3 param_32 = sum;
        float param_33 = valence;
        FLT_flutter_local_processPoint(param_28, param_29, param_30, param_31, param_32, param_33);
        sum = param_32;
        valence = param_33;
    }
    if (uNumPoints > 5.0)
    {
        vec2 param_34 = uPoint6;
        vec3 param_35 = uColor6;
        vec2 param_36 = uv;
        float param_37 = blend;
        vec3 param_38 = sum;
        float param_39 = valence;
        FLT_flutter_local_processPoint(param_34, param_35, param_36, param_37, param_38, param_39);
        sum = param_38;
        valence = param_39;
    }
    if (valence != 0.0)
    {
        sum /= vec3(valence);
    }
    vec2 param_40 = (uv * uSize) * 0.100000001490116119384765625;
    float n = FLT_flutter_local_complexNoise(param_40);
    sum = mix(sum, sum * n, vec3(uNoiseIntensity * (-1.0)));
    sum = pow(sum, vec3(0.4545454680919647216796875));
    fragColor = vec4(sum, 1.0);
}

half4 main(float2 iFragCoord)
{
      flutter_FragCoord = float4(iFragCoord, 0, 0);
      FLT_main();
      return fragColor;
}
     @      \         l  0        |   @      R(   
                                    uColor6 (                                       uColor5 (                                       uColor4 (   
                                    uColor3 2(   	                                    uColor2 j(                                       uColor1 (                                       uPoint6 (                                       uPoint5 (                                       uPoint4 J(                                       uPoint3 $                                   uPoint2    (              $                                   uPoint1    ,              (                                       uVars  $                                               uSize   !   point_mesh_gradient_fragment_main   